# 🚀 Business Platform

A comprehensive multi-tenant business management platform combining CRM, Accounting, Task Management, HR & Payroll - built for the Bahrain market.

## Features

### 📊 CRM (GoHighLevel-style)
- Contact & Lead Management
- Pipeline & Opportunity Tracking
- Segments & Smart Lists
- Tags & Custom Fields
- Form Builder
- Activity Timeline

### 💰 Accounting (QuickBooks-style)
- Invoicing & Recurring Invoices
- Bills & Expenses
- Chart of Accounts
- Journal Entries
- Bank Reconciliation
- VAT Tax Reports (Bahrain NBR compliant)

### ✅ Task Management (Monday.com-style)
- Projects & Kanban Boards
- Tasks, Subtasks & Checklists
- Milestones
- Time Tracking
- Team Collaboration

### 👥 HR & Payroll
- Employee Management
- Attendance (Check-in/out)
- Leave Management
- Payroll with GOSI calculations
  - Bahraini: 7% employee / 12% employer
  - Expat: 1% employee / 3% employer
- Payslip Generation

### 📧 Communication & Marketing
- Email Campaigns
- SMS Integration (Twilio)
- WhatsApp Business API
- Workflow Automation
- Email Templates

### 📈 Reports
- Balance Sheet
- Profit & Loss
- Cash Flow Statement
- Aging Reports (AR/AP)
- Tax Reports
- Sales Reports

## Tech Stack

- **Backend:** Laravel 11, PHP 8.3
- **Database:** MySQL 8.0
- **Cache:** Redis
- **Frontend:** Vue.js 3, Pinia, Tailwind CSS
- **Authentication:** Laravel Sanctum

## Quick Start

### Option 1: Docker (Recommended)

```bash
# Clone the repository
git clone https://github.com/your-repo/business-platform.git
cd business-platform

# Copy environment file
cp .env.example .env

# Start with Docker
./docker-deploy.sh
```

Access at: http://localhost

### Option 2: Manual Installation

```bash
# Install PHP dependencies
composer install

# Install Node dependencies
npm install

# Copy environment file
cp .env.example .env

# Generate app key
php artisan key:generate

# Configure database in .env, then:
php artisan migrate --seed

# Build frontend
npm run build

# Start development server
php artisan serve
```

## Configuration

### Environment Variables

```env
APP_NAME="Business Platform"
APP_URL=http://localhost

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_DATABASE=business_platform
DB_USERNAME=root
DB_PASSWORD=secret

REDIS_HOST=127.0.0.1

# Email
MAIL_MAILER=smtp
MAIL_HOST=smtp.example.com

# SMS (Twilio)
TWILIO_SID=your_sid
TWILIO_TOKEN=your_token
TWILIO_FROM=+1234567890

# WhatsApp
WHATSAPP_TOKEN=your_token
WHATSAPP_PHONE_ID=your_phone_id

# Stripe (Payments)
STRIPE_KEY=pk_live_xxx
STRIPE_SECRET=sk_live_xxx
```

## Default Credentials

After seeding:
- **Email:** admin@example.com
- **Password:** password

## API Documentation

See [docs/API.md](docs/API.md) for full API documentation.

## Production Deployment

```bash
# Run deployment script
./deploy.sh

# Or manually:
composer install --no-dev --optimize-autoloader
npm ci && npm run build
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

### Queue Worker

```bash
php artisan queue:work --daemon
```

### Scheduler (Cron)

```cron
* * * * * cd /path-to-project && php artisan schedule:run >> /dev/null 2>&1
```

## Bahrain-Specific Features

- 🇧🇭 BHD Currency (3 decimal places)
- 🕐 Asia/Bahrain Timezone
- 📋 GOSI Social Insurance calculations
- 🧾 VAT/NBR Tax reporting
- 📄 CR Number fields for contacts

## License

Proprietary - All rights reserved.

## Support

For support, contact: info@setupinbahrain.com
