<?php

namespace App\Console\Commands;

use App\Jobs\ProcessRecurringInvoices;
use Illuminate\Console\Command;

class ProcessRecurringInvoicesCommand extends Command
{
    protected $signature = 'invoices:process-recurring';
    protected $description = 'Process recurring invoices and generate new invoices';

    public function handle(): int
    {
        $this->info('Processing recurring invoices...');
        
        ProcessRecurringInvoices::dispatch();
        
        $this->info('Recurring invoices job queued!');
        
        return Command::SUCCESS;
    }
}
