<?php

namespace App\Console\Commands;

use App\Jobs\SyncBankTransactions;
use App\Models\BankAccount;
use Illuminate\Console\Command;

class SyncBankAccountsCommand extends Command
{
    protected $signature = 'banking:sync {--account= : Specific bank account ID}';
    protected $description = 'Sync bank transactions from connected accounts';

    public function handle(): int
    {
        $query = BankAccount::whereNotNull('plaid_access_token')
            ->where('is_active', true);

        if ($accountId = $this->option('account')) {
            $query->where('id', $accountId);
        }

        $accounts = $query->get();

        $this->info("Found {$accounts->count()} accounts to sync");

        foreach ($accounts as $account) {
            $this->line("  - Syncing: {$account->name}");
            SyncBankTransactions::dispatch($account);
        }

        $this->info('Bank sync jobs queued!');

        return Command::SUCCESS;
    }
}
