<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class SendEmailRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'to' => 'required|array|min:1',
            'to.*' => 'email',
            'cc' => 'nullable|array',
            'cc.*' => 'email',
            'bcc' => 'nullable|array',
            'bcc.*' => 'email',
            'subject' => 'required|string|max:255',
            'body' => 'required|string',
            'email_account_id' => 'nullable|exists:email_accounts,id',
            'template_id' => 'nullable|exists:email_templates,id',
            'contact_id' => 'nullable|exists:contacts,id',
            'attachments' => 'nullable|array',
            'attachments.*' => 'file|max:10240',
            'schedule_at' => 'nullable|date|after:now',
        ];
    }
}
