<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class SendWhatsappRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'to' => 'required|string|max:20',
            'message_type' => 'required|in:text,template,image,document',
            'content' => 'required_if:message_type,text|string',
            'template_name' => 'required_if:message_type,template|string|max:255',
            'template_params' => 'nullable|array',
            'media_url' => 'required_if:message_type,image,document|url',
            'contact_id' => 'nullable|exists:contacts,id',
        ];
    }
}
