<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreTaskRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'project_id' => 'required|exists:projects,id',
            'title' => 'required|string|max:255',
            'description' => 'nullable|string|max:10000',
            'status_id' => 'nullable|exists:task_statuses,id',
            'priority' => 'nullable|in:lowest,low,normal,high,highest',
            'type' => 'nullable|in:task,bug,feature,improvement,subtask',
            'start_date' => 'nullable|date',
            'due_date' => 'nullable|date|after_or_equal:start_date',
            'estimated_hours' => 'nullable|numeric|min:0|max:9999',
            'parent_id' => 'nullable|exists:tasks,id',
            'group_id' => 'nullable|exists:task_groups,id',
            'milestone_id' => 'nullable|exists:milestones,id',
            'assignee_ids' => 'nullable|array',
            'assignee_ids.*' => 'exists:users,id',
            'tag_ids' => 'nullable|array',
            'tag_ids.*' => 'exists:tags,id',
            'checklist' => 'nullable|array',
            'checklist.*.name' => 'required|string|max:255',
            'checklist.*.items' => 'nullable|array',
            'checklist.*.items.*' => 'string|max:255',
        ];
    }

    public function messages(): array
    {
        return [
            'project_id.required' => 'Please select a project',
            'title.required' => 'Task title is required',
            'due_date.after_or_equal' => 'Due date must be after start date',
        ];
    }
}
