<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateOpportunityRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->tenant_id === $this->route('opportunity')->tenant_id;
    }

    public function rules(): array
    {
        return [
            'name' => 'sometimes|string|max:255',
            'contact_id' => 'sometimes|exists:contacts,id',
            'stage_id' => 'sometimes|exists:pipeline_stages,id',
            'value' => 'sometimes|numeric|min:0',
            'currency' => 'nullable|string|size:3',
            'probability' => 'nullable|integer|min:0|max:100',
            'expected_close_date' => 'nullable|date',
            'description' => 'nullable|string|max:2000',
            'source' => 'nullable|string|max:50',
            'owner_id' => 'nullable|exists:users,id',
        ];
    }
}
