<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateTaskRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->tenant_id === $this->route('task')->tenant_id;
    }

    public function rules(): array
    {
        return [
            'title' => 'sometimes|string|max:255',
            'description' => 'nullable|string',
            'status_id' => 'sometimes|exists:task_statuses,id',
            'priority' => 'sometimes|in:low,medium,high,urgent',
            'type' => 'sometimes|in:task,bug,feature,improvement',
            'start_date' => 'nullable|date',
            'due_date' => 'nullable|date|after_or_equal:start_date',
            'estimated_hours' => 'nullable|numeric|min:0',
            'assignee_ids' => 'nullable|array',
            'assignee_ids.*' => 'exists:users,id',
            'parent_task_id' => 'nullable|exists:tasks,id',
        ];
    }
}
