<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class WorkflowResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'trigger_type' => $this->trigger_type,
            'trigger_conditions' => $this->trigger_conditions,
            'is_active' => $this->is_active,
            'steps' => $this->whenLoaded('steps', fn() => $this->steps->map(fn($step) => [
                'id' => $step->id,
                'order' => $step->order,
                'type' => $step->type,
                'config' => $step->config,
                'delay_minutes' => $step->delay_minutes,
            ])),
            'enrollments_count' => $this->whenCounted('enrollments'),
            'created_at' => $this->created_at->toIso8601String(),
        ];
    }
}
