<?php

namespace App\Jobs;

use App\Models\Invoice;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Storage;

class GenerateInvoicePdf implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(public Invoice $invoice) {}

    public function handle(): void
    {
        $invoice = $this->invoice->load(['tenant', 'contact', 'items.taxRate']);

        $pdf = Pdf::loadView('pdf.invoice', compact('invoice'));
        
        $filename = "invoices/{$invoice->tenant_id}/{$invoice->invoice_number}.pdf";
        
        Storage::put($filename, $pdf->output());

        $this->invoice->update(['pdf_path' => $filename]);
    }
}
