<?php

namespace App\Jobs;

use App\Events\FormSubmitted;
use App\Models\FormSubmission;
use App\Services\WorkflowService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessFormSubmission implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(public FormSubmission $submission) {}

    public function handle(WorkflowService $workflowService): void
    {
        // Trigger workflows for form submission
        if ($this->submission->contact) {
            $workflowService->triggerForContact(
                $this->submission->contact,
                'form_submitted',
                [
                    'form_id' => $this->submission->form_id,
                    'form_name' => $this->submission->form->name,
                    'submission_data' => $this->submission->data,
                ]
            );
        }

        // Send notification to form owner
        if ($this->submission->form->notify_email) {
            // Send notification email
        }
    }
}
