<?php

namespace App\Jobs;

use App\Models\PayrollRun;
use App\Services\PayrollService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessPayroll implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $timeout = 600;

    public function __construct(public PayrollRun $payrollRun) {}

    public function handle(PayrollService $payrollService): void
    {
        $payrollService->process($this->payrollRun);
    }
}
