<?php

namespace App\Jobs;

use App\Models\RecurringInvoice;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessRecurringInvoices implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 3;

    public function handle(): void
    {
        $recurringInvoices = RecurringInvoice::where('status', RecurringInvoice::STATUS_ACTIVE)
            ->where('next_invoice_date', '<=', now())
            ->get();

        foreach ($recurringInvoices as $recurring) {
            try {
                $invoice = $recurring->generateInvoice();
                
                if ($invoice) {
                    \Log::info('Generated recurring invoice', [
                        'recurring_id' => $recurring->id,
                        'invoice_id' => $invoice->id,
                    ]);
                }
            } catch (\Exception $e) {
                \Log::error('Failed to generate recurring invoice', [
                    'recurring_id' => $recurring->id,
                    'error' => $e->getMessage(),
                ]);
            }
        }
    }
}
