<?php

namespace App\Jobs;

use App\Models\WorkflowEnrollment;
use App\Services\WorkflowService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessWorkflowEnrollments implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 3;

    public function handle(WorkflowService $workflowService): void
    {
        $enrollments = WorkflowEnrollment::due()
            ->with(['workflow', 'contact'])
            ->limit(100)
            ->get();

        foreach ($enrollments as $enrollment) {
            try {
                $workflowService->processEnrollment($enrollment);
            } catch (\Exception $e) {
                $enrollment->fail($e->getMessage());
                
                \Log::error('Workflow enrollment processing failed', [
                    'enrollment_id' => $enrollment->id,
                    'workflow_id' => $enrollment->workflow_id,
                    'error' => $e->getMessage(),
                ]);
            }
        }
    }
}
