<?php

namespace App\Jobs;

use App\Models\WorkflowEnrollment;
use App\Services\WorkflowEngine;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessWorkflowStep implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 3;
    public int $backoff = 60;

    public function __construct(
        public WorkflowEnrollment $enrollment,
        public int $stepIndex
    ) {}

    public function handle(WorkflowEngine $engine): void
    {
        $engine->processStep($this->enrollment, $this->stepIndex);
    }

    public function failed(\Throwable $exception): void
    {
        $this->enrollment->update([
            'status' => 'failed',
            'error' => $exception->getMessage(),
        ]);
    }
}
