<?php

namespace App\Jobs;

use App\Models\LeaveRequest;
use App\Notifications\LeaveRequestNotification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendLeaveNotification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public LeaveRequest $leaveRequest,
        public string $type
    ) {}

    public function handle(): void
    {
        $employee = $this->leaveRequest->employee;
        $manager = $employee->manager;

        match ($this->type) {
            'submitted' => $manager?->user->notify(new LeaveRequestNotification($this->leaveRequest, 'submitted')),
            'approved' => $employee->user->notify(new LeaveRequestNotification($this->leaveRequest, 'approved')),
            'rejected' => $employee->user->notify(new LeaveRequestNotification($this->leaveRequest, 'rejected')),
            default => null,
        };
    }
}
