<?php

namespace App\Listeners;

use App\Events\ContactCreated;
use App\Services\WorkflowService;
use Illuminate\Contracts\Queue\ShouldQueue;

class HandleContactCreated implements ShouldQueue
{
    public function __construct(protected WorkflowService $workflowService) {}

    public function handle(ContactCreated $event): void
    {
        $this->workflowService->triggerForContact($event->contact, 'contact_created');
    }
}
