<?php

namespace App\Listeners;

use App\Events\OpportunityStageChanged;
use App\Services\WorkflowService;
use Illuminate\Contracts\Queue\ShouldQueue;

class HandleOpportunityStageChanged implements ShouldQueue
{
    public function __construct(protected WorkflowService $workflowService) {}

    public function handle(OpportunityStageChanged $event): void
    {
        $this->workflowService->triggerForOpportunity(
            $event->opportunity,
            'opportunity_stage_changed',
            [
                'old_stage_id' => $event->oldStage?->id,
                'new_stage_id' => $event->newStage->id,
            ]
        );
    }
}
