<?php

namespace App\Listeners;

use App\Events\ExpenseApproved;
use App\Notifications\ExpenseApprovedNotification;

class SendExpenseApprovedNotification
{
    public function handle(ExpenseApproved $event): void
    {
        $expense = $event->expense;
        
        if ($expense->createdBy) {
            $expense->createdBy->notify(new ExpenseApprovedNotification($expense));
        }
    }
}
