<?php

namespace App\Listeners;

use App\Events\InvoiceOverdue;
use App\Notifications\InvoiceOverdueNotification;

class SendInvoiceOverdueReminder
{
    public function handle(InvoiceOverdue $event): void
    {
        $invoice = $event->invoice;
        $contact = $invoice->contact;

        if ($contact && $contact->email) {
            $contact->notify(new InvoiceOverdueNotification($invoice));
        }
    }
}
