<?php

namespace App\Listeners;

use App\Events\PayrollProcessed;
use App\Jobs\GeneratePayslipPdf;
use App\Notifications\PayslipNotification;

class SendPayslipNotification
{
    public function handle(PayrollProcessed $event): void
    {
        $payrollRun = $event->payrollRun;

        foreach ($payrollRun->items as $item) {
            GeneratePayslipPdf::dispatch($item);
            
            $employee = $item->employee;
            if ($employee && $employee->user) {
                $employee->user->notify(new PayslipNotification($item));
            }
        }
    }
}
