<?php

namespace App\Listeners;

use App\Events\EmployeeCreated;
use App\Notifications\WelcomeEmployeeNotification;

class SendWelcomeToNewEmployee
{
    public function handle(EmployeeCreated $event): void
    {
        $employee = $event->employee;
        
        if ($employee->user) {
            $employee->user->notify(new WelcomeEmployeeNotification($employee));
        }
    }
}
