<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Attendance extends BaseModel
{
    use HasFactory;

    protected $table = 'attendances';

    protected $fillable = [
        'tenant_id', 'employee_id', 'date', 'check_in', 'check_out',
        'status', 'hours_worked', 'notes', 'ip_address',
    ];

    protected $casts = [
        'date' => 'date',
        'check_in' => 'datetime:H:i:s',
        'check_out' => 'datetime:H:i:s',
        'hours_worked' => 'decimal:2',
    ];

    public function employee(): BelongsTo
    {
        return $this->belongsTo(Employee::class);
    }

    public function calculateHoursWorked(): float
    {
        if (!$this->check_in || !$this->check_out) {
            return 0;
        }

        return round(
            ($this->check_out->timestamp - $this->check_in->timestamp) / 3600,
            2
        );
    }

    public function isLate(): bool
    {
        $workStart = '09:00:00';
        return $this->check_in && $this->check_in->format('H:i:s') > $workStart;
    }
}
