<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LeaveBalance extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'tenant_id', 'employee_id', 'leave_type_id', 'year',
        'entitled', 'used', 'carried_over', 'adjusted',
    ];

    protected $casts = [
        'entitled' => 'decimal:1',
        'used' => 'decimal:1',
        'carried_over' => 'decimal:1',
        'adjusted' => 'decimal:1',
    ];

    public function employee(): BelongsTo
    {
        return $this->belongsTo(Employee::class);
    }

    public function leaveType(): BelongsTo
    {
        return $this->belongsTo(LeaveType::class);
    }

    public function getRemainingAttribute(): float
    {
        return $this->entitled + $this->carried_over + $this->adjusted - $this->used;
    }
}
