<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends BaseModel
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'tenant_id',
        'name',
        'sku',
        'description',
        'type',
        'unit_price',
        'cost_price',
        'tax_rate_id',
        'account_id',
        'is_active',
    ];

    protected $casts = [
        'unit_price' => 'decimal:3',
        'cost_price' => 'decimal:3',
        'is_active' => 'boolean',
    ];

    const TYPE_SERVICE = 'service';
    const TYPE_PRODUCT = 'product';

    public function taxRate()
    {
        return $this->belongsTo(TaxRate::class);
    }

    public function account()
    {
        return $this->belongsTo(ChartOfAccount::class, 'account_id');
    }

    public function getProfit(): float
    {
        return $this->unit_price - ($this->cost_price ?? 0);
    }

    public function getProfitMargin(): float
    {
        if ($this->unit_price <= 0) return 0;
        return ($this->getProfit() / $this->unit_price) * 100;
    }
}
