<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TaskChecklist extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'tenant_id',
        'task_id',
        'name',
        'position',
    ];

    protected $casts = [
        'position' => 'integer',
    ];

    public function task(): BelongsTo
    {
        return $this->belongsTo(Task::class);
    }

    public function items(): HasMany
    {
        return $this->hasMany(ChecklistItem::class, 'checklist_id')->orderBy('position');
    }

    public function getProgress(): float
    {
        $total = $this->items()->count();
        
        if ($total === 0) {
            return 0;
        }

        $completed = $this->items()->where('is_completed', true)->count();
        return ($completed / $total) * 100;
    }

    public function getCompletedCount(): int
    {
        return $this->items()->where('is_completed', true)->count();
    }

    public function getTotalCount(): int
    {
        return $this->items()->count();
    }

    public function isComplete(): bool
    {
        return $this->getProgress() >= 100;
    }
}
