<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TaskGroup extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'tenant_id',
        'project_id',
        'name',
        'description',
        'color',
        'position',
        'is_collapsed',
    ];

    protected $casts = [
        'position' => 'integer',
        'is_collapsed' => 'boolean',
    ];

    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }

    public function tasks(): HasMany
    {
        return $this->hasMany(Task::class, 'group_id')->orderBy('position');
    }

    public function getTaskCount(): int
    {
        return $this->tasks()->count();
    }

    public function getCompletedTaskCount(): int
    {
        return $this->tasks()
            ->whereHas('status', fn($q) => $q->where('is_completed', true))
            ->count();
    }
}
