<?php

namespace App\Notifications;

use App\Models\Expense;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ExpenseApprovedNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(public Expense $expense) {}

    public function via($notifiable): array
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject("Expense Approved: {$this->expense->description}")
            ->greeting("Hello {$notifiable->first_name},")
            ->line("Your expense claim has been approved.")
            ->line("Description: {$this->expense->description}")
            ->line("Amount: {$this->expense->currency} " . number_format($this->expense->amount, 3))
            ->action('View Expense', url("/expenses/{$this->expense->id}"))
            ->line('Reimbursement will be processed in the next payroll run.');
    }

    public function toArray($notifiable): array
    {
        return [
            'type' => 'expense_approved',
            'expense_id' => $this->expense->id,
            'description' => $this->expense->description,
            'amount' => $this->expense->amount,
        ];
    }
}
