<?php

namespace App\Notifications;

use App\Models\PayrollItem;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PayslipNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(public PayrollItem $payrollItem) {}

    public function via($notifiable): array
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable): MailMessage
    {
        $run = $this->payrollItem->payrollRun;

        return (new MailMessage)
            ->subject("Your Payslip is Ready - {$run->pay_period_start->format('M Y')}")
            ->greeting("Hello {$notifiable->first_name},")
            ->line("Your payslip for the period {$run->pay_period_start->format('M d')} - {$run->pay_period_end->format('M d, Y')} is now available.")
            ->line("Net Salary: {$this->payrollItem->currency} " . number_format($this->payrollItem->net_salary, 3))
            ->action('View Payslip', url("/payroll/payslip/{$this->payrollItem->id}"))
            ->line('Payment will be processed on ' . $run->payment_date->format('M d, Y'));
    }

    public function toArray($notifiable): array
    {
        return [
            'type' => 'payslip_ready',
            'payroll_item_id' => $this->payrollItem->id,
            'net_salary' => $this->payrollItem->net_salary,
            'payment_date' => $this->payrollItem->payrollRun->payment_date,
        ];
    }
}
