<?php

namespace App\Notifications;

use App\Models\Task;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class TaskDueSoonNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(public Task $task, public int $daysUntilDue) {}

    public function via($notifiable): array
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable): MailMessage
    {
        $dueText = $this->daysUntilDue === 0 ? 'today' : "in {$this->daysUntilDue} day(s)";
        
        return (new MailMessage)
            ->subject('Task Due ' . ucfirst($dueText) . ': ' . $this->task->title)
            ->line("Your task is due {$dueText}.")
            ->line('Task: ' . $this->task->title)
            ->line('Project: ' . $this->task->project->name)
            ->action('View Task', url('/tasks/' . $this->task->id));
    }

    public function toArray($notifiable): array
    {
        return [
            'type' => 'task_due_soon',
            'task_id' => $this->task->id,
            'days_until_due' => $this->daysUntilDue,
        ];
    }
}
