<?php

namespace App\Policies;

use App\Models\Employee;
use App\Models\User;

class EmployeePolicy
{
    public function viewAny(User $user): bool
    {
        return true;
    }

    public function view(User $user, Employee $employee): bool
    {
        return $user->tenant_id === $employee->tenant_id;
    }

    public function create(User $user): bool
    {
        return $user->hasPermissionTo('employees.create');
    }

    public function update(User $user, Employee $employee): bool
    {
        return $user->tenant_id === $employee->tenant_id && $user->hasPermissionTo('employees.update');
    }

    public function delete(User $user, Employee $employee): bool
    {
        return $user->tenant_id === $employee->tenant_id && $user->hasPermissionTo('employees.delete');
    }

    public function approve(User $user, Employee $employee): bool
    {
        return $user->tenant_id === $employee->tenant_id && $user->hasPermissionTo('hr.approve');
    }
}
