<?php

namespace App\Policies;

use App\Models\Invoice;
use App\Models\User;

class InvoicePolicy
{
    public function viewAny(User $user): bool
    {
        return true;
    }

    public function view(User $user, Invoice $invoice): bool
    {
        return $user->tenant_id === $invoice->tenant_id;
    }

    public function create(User $user): bool
    {
        return true;
    }

    public function update(User $user, Invoice $invoice): bool
    {
        return $user->tenant_id === $invoice->tenant_id && 
               !in_array($invoice->status, ['paid', 'void']);
    }

    public function delete(User $user, Invoice $invoice): bool
    {
        return $user->tenant_id === $invoice->tenant_id && 
               $invoice->status === 'draft';
    }

    public function send(User $user, Invoice $invoice): bool
    {
        return $user->tenant_id === $invoice->tenant_id && 
               in_array($invoice->status, ['draft', 'sent']);
    }

    public function recordPayment(User $user, Invoice $invoice): bool
    {
        return $user->tenant_id === $invoice->tenant_id && 
               !in_array($invoice->status, ['paid', 'void']);
    }

    public function void(User $user, Invoice $invoice): bool
    {
        return $user->tenant_id === $invoice->tenant_id && 
               $invoice->amount_paid == 0;
    }
}
