<?php

namespace App\Policies;

use App\Models\PayrollRun;
use App\Models\User;

class PayrollRunPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->hasPermissionTo('payroll.view');
    }

    public function view(User $user, PayrollRun $run): bool
    {
        return $user->tenant_id === $run->tenant_id && $user->hasPermissionTo('payroll.view');
    }

    public function create(User $user): bool
    {
        return $user->hasPermissionTo('payroll.create');
    }

    public function update(User $user, PayrollRun $run): bool
    {
        return $user->tenant_id === $run->tenant_id && $user->hasPermissionTo('payroll.update');
    }

    public function delete(User $user, PayrollRun $run): bool
    {
        return $user->tenant_id === $run->tenant_id && $user->hasPermissionTo('payroll.delete');
    }

    public function approve(User $user, PayrollRun $run): bool
    {
        return $user->tenant_id === $run->tenant_id && $user->hasPermissionTo('payroll.approve');
    }
}
