<?php

namespace App\Services;

use App\Events\FormSubmitted;
use App\Models\Form;
use App\Models\FormSubmission;
use Illuminate\Support\Str;

class FormService
{
    public function create(int $tenantId, array $data): Form
    {
        return Form::create([
            'tenant_id' => $tenantId,
            'name' => $data['name'],
            'slug' => Str::slug($data['name']) . '-' . Str::random(6),
            'description' => $data['description'] ?? null,
            'fields' => $data['fields'],
            'settings' => $data['settings'] ?? [],
            'thank_you_message' => $data['thank_you_message'] ?? 'Thank you for your submission!',
            'redirect_url' => $data['redirect_url'] ?? null,
            'is_active' => $data['is_active'] ?? true,
        ]);
    }

    public function submit(Form $form, array $data, ?string $ipAddress = null): FormSubmission
    {
        $submission = FormSubmission::create([
            'tenant_id' => $form->tenant_id,
            'form_id' => $form->id,
            'data' => $data,
            'ip_address' => $ipAddress,
            'user_agent' => request()->userAgent(),
        ]);

        event(new FormSubmitted($form, $submission));

        return $submission;
    }

    public function duplicate(Form $form): Form
    {
        $newForm = $form->replicate();
        $newForm->name = $form->name . ' (Copy)';
        $newForm->slug = Str::slug($newForm->name) . '-' . Str::random(6);
        $newForm->save();

        return $newForm;
    }
}
