<?php

namespace Database\Factories;

use App\Models\Bill;
use Illuminate\Database\Eloquent\Factories\Factory;

class BillFactory extends Factory
{
    protected $model = Bill::class;

    public function definition(): array
    {
        $subtotal = $this->faker->randomFloat(3, 100, 10000);
        $taxAmount = $subtotal * 0.1;

        return [
            'bill_number' => 'BILL-' . str_pad($this->faker->unique()->numberBetween(1, 9999), 4, '0', STR_PAD_LEFT),
            'bill_date' => $this->faker->dateTimeBetween('-2 months', 'now'),
            'due_date' => $this->faker->dateTimeBetween('now', '+30 days'),
            'currency' => 'BHD',
            'exchange_rate' => 1.0,
            'subtotal' => $subtotal,
            'tax_amount' => $taxAmount,
            'total' => $subtotal + $taxAmount,
            'amount_paid' => 0,
            'status' => 'received',
        ];
    }
}
