<?php

namespace Database\Factories;

use App\Models\Campaign;
use Illuminate\Database\Eloquent\Factories\Factory;

class CampaignFactory extends Factory
{
    protected $model = Campaign::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->words(3, true) . ' Campaign',
            'type' => $this->faker->randomElement(['email', 'sms', 'whatsapp']),
            'subject' => $this->faker->sentence(),
            'content' => $this->faker->paragraphs(3, true),
            'from_name' => $this->faker->company(),
            'from_email' => $this->faker->companyEmail(),
            'status' => Campaign::STATUS_DRAFT,
            'recipient_count' => 0,
            'sent_count' => 0,
            'delivered_count' => 0,
            'opened_count' => 0,
            'clicked_count' => 0,
        ];
    }

    public function sent(): static
    {
        return $this->state(fn(array $attributes) => [
            'status' => Campaign::STATUS_SENT,
            'sent_at' => now(),
        ]);
    }
}
