<?php

namespace Database\Factories;

use App\Models\Contact;
use Illuminate\Database\Eloquent\Factories\Factory;

class ContactFactory extends Factory
{
    protected $model = Contact::class;

    public function definition(): array
    {
        return [
            'first_name' => $this->faker->firstName(),
            'last_name' => $this->faker->lastName(),
            'email' => $this->faker->unique()->safeEmail(),
            'phone' => $this->faker->phoneNumber(),
            'mobile' => $this->faker->phoneNumber(),
            'company_name' => $this->faker->company(),
            'job_title' => $this->faker->jobTitle(),
            'address_line_1' => $this->faker->streetAddress(),
            'city' => $this->faker->city(),
            'country' => 'BH',
            'lead_status' => $this->faker->randomElement(['new', 'lead', 'qualified', 'customer']),
            'source' => $this->faker->randomElement(['website', 'referral', 'social', 'other']),
            'is_subscribed' => true,
        ];
    }
}
