<?php

namespace Database\Factories;

use App\Models\Employee;
use Illuminate\Database\Eloquent\Factories\Factory;

class EmployeeFactory extends Factory
{
    protected $model = Employee::class;

    public function definition(): array
    {
        return [
            'employee_id' => 'EMP-' . str_pad($this->faker->unique()->numberBetween(1, 9999), 4, '0', STR_PAD_LEFT),
            'hire_date' => $this->faker->dateTimeBetween('-5 years', '-1 month'),
            'job_title' => $this->faker->jobTitle(),
            'employment_type' => $this->faker->randomElement(['full_time', 'part_time', 'contract']),
            'status' => 'active',
            'nationality' => $this->faker->countryCode(),
            'date_of_birth' => $this->faker->dateTimeBetween('-60 years', '-20 years'),
            'gender' => $this->faker->randomElement(['male', 'female']),
            'marital_status' => $this->faker->randomElement(['single', 'married']),
            'cpr_number' => $this->faker->numerify('#########'),
            'passport_number' => $this->faker->bothify('??#######'),
        ];
    }
}
