<?php

namespace Database\Factories;

use App\Models\Expense;
use Illuminate\Database\Eloquent\Factories\Factory;

class ExpenseFactory extends Factory
{
    protected $model = Expense::class;

    public function definition(): array
    {
        return [
            'expense_date' => $this->faker->dateTimeBetween('-30 days', 'now'),
            'description' => $this->faker->sentence(),
            'amount' => $this->faker->randomFloat(3, 10, 1000),
            'currency' => 'BHD',
            'category' => $this->faker->randomElement(['travel', 'office', 'utilities', 'marketing', 'supplies']),
            'payment_method' => $this->faker->randomElement(['cash', 'credit_card', 'bank_transfer']),
            'status' => $this->faker->randomElement(['pending', 'approved', 'rejected']),
            'is_billable' => $this->faker->boolean(30),
        ];
    }
}
