<?php

namespace Database\Factories;

use App\Models\LeaveType;
use Illuminate\Database\Eloquent\Factories\Factory;

class LeaveTypeFactory extends Factory
{
    protected $model = LeaveType::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->randomElement(['Annual Leave', 'Sick Leave', 'Unpaid Leave']),
            'days_per_year' => $this->faker->randomElement([30, 14, 0]),
            'is_paid' => true,
            'requires_approval' => true,
            'max_carry_forward' => 5,
            'color' => $this->faker->hexColor(),
            'is_active' => true,
        ];
    }
}
