<?php

namespace Database\Factories;

use App\Models\Opportunity;
use Illuminate\Database\Eloquent\Factories\Factory;

class OpportunityFactory extends Factory
{
    protected $model = Opportunity::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->words(3, true),
            'value' => $this->faker->randomFloat(3, 1000, 100000),
            'currency' => 'BHD',
            'probability' => $this->faker->randomElement([10, 25, 50, 75, 90]),
            'expected_close_date' => $this->faker->dateTimeBetween('now', '+3 months'),
            'status' => 'open',
            'source' => $this->faker->randomElement(['website', 'referral', 'cold_call', 'event']),
            'description' => $this->faker->optional()->paragraph(),
        ];
    }
}
