<?php

namespace Database\Factories;

use App\Models\PayrollRun;
use Illuminate\Database\Eloquent\Factories\Factory;

class PayrollRunFactory extends Factory
{
    protected $model = PayrollRun::class;

    public function definition(): array
    {
        $startDate = $this->faker->dateTimeBetween('-2 months', 'now');
        $endDate = (clone $startDate)->modify('last day of this month');

        return [
            'pay_period_start' => $startDate->format('Y-m-01'),
            'pay_period_end' => $endDate->format('Y-m-d'),
            'payment_date' => (clone $endDate)->modify('+5 days')->format('Y-m-d'),
            'status' => PayrollRun::STATUS_DRAFT,
            'total_gross' => 0,
            'total_net' => 0,
        ];
    }
}
