<?php

namespace Database\Factories;

use App\Models\PipelineStage;
use Illuminate\Database\Eloquent\Factories\Factory;

class PipelineStageFactory extends Factory
{
    protected $model = PipelineStage::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->randomElement(['Lead', 'Qualified', 'Proposal', 'Negotiation', 'Won']),
            'color' => $this->faker->hexColor(),
            'probability' => $this->faker->randomElement([10, 25, 50, 75, 100]),
            'position' => $this->faker->numberBetween(1, 5),
        ];
    }
}
