<?php

namespace Database\Factories;

use App\Models\Project;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProjectFactory extends Factory
{
    protected $model = Project::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->words(3, true),
            'description' => $this->faker->paragraph(),
            'color' => $this->faker->hexColor(),
            'status' => 'active',
            'visibility' => 'team',
            'start_date' => $this->faker->dateTimeBetween('-1 month', 'now'),
            'end_date' => $this->faker->optional()->dateTimeBetween('+1 month', '+6 months'),
            'budget' => $this->faker->optional()->randomFloat(3, 1000, 50000),
            'settings' => [],
        ];
    }
}
