<?php

namespace Database\Factories;

use App\Models\Task;
use Illuminate\Database\Eloquent\Factories\Factory;

class TaskFactory extends Factory
{
    protected $model = Task::class;

    public function definition(): array
    {
        return [
            'title' => $this->faker->sentence(4),
            'description' => $this->faker->optional()->paragraph(),
            'type' => $this->faker->randomElement(['task', 'bug', 'feature']),
            'priority' => $this->faker->randomElement(['low', 'medium', 'high', 'urgent']),
            'start_date' => $this->faker->optional()->dateTimeBetween('-1 week', 'now'),
            'due_date' => $this->faker->optional()->dateTimeBetween('now', '+2 weeks'),
            'estimated_hours' => $this->faker->optional()->randomFloat(1, 1, 40),
            'position' => $this->faker->numberBetween(1, 100),
        ];
    }
}
