<?php

namespace Database\Factories;

use App\Models\Vendor;
use Illuminate\Database\Eloquent\Factories\Factory;

class VendorFactory extends Factory
{
    protected $model = Vendor::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->company(),
            'email' => $this->faker->companyEmail(),
            'phone' => $this->faker->phoneNumber(),
            'website' => $this->faker->url(),
            'address_line_1' => $this->faker->streetAddress(),
            'city' => $this->faker->city(),
            'country' => 'BH',
            'tax_number' => $this->faker->numerify('##########'),
            'currency' => 'BHD',
            'payment_terms' => $this->faker->randomElement([15, 30, 45, 60]),
            'is_active' => true,
        ];
    }
}
