<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->cascadeOnDelete();
            $table->foreignId('account_id')->constrained('chart_of_accounts')->cascadeOnDelete();
            $table->foreignId('vendor_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('contact_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('project_id')->nullable()->constrained()->nullOnDelete();
            $table->string('expense_number')->unique();
            $table->date('expense_date');
            $table->decimal('amount', 15, 3);
            $table->string('currency', 3)->default('BHD');
            $table->decimal('exchange_rate', 15, 6)->default(1);
            $table->foreignId('tax_rate_id')->nullable()->constrained('tax_rates')->nullOnDelete();
            $table->decimal('tax_amount', 15, 3)->default(0);
            $table->decimal('total', 15, 3);
            $table->string('category')->nullable();
            $table->text('description')->nullable();
            $table->string('receipt_path')->nullable();
            $table->boolean('is_billable')->default(false);
            $table->boolean('is_billed')->default(false);
            $table->boolean('is_reimbursable')->default(false);
            $table->boolean('is_reimbursed')->default(false);
            $table->string('payment_method')->nullable();
            $table->string('reference')->nullable();
            $table->string('status')->default('pending');
            $table->foreignId('approved_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamp('approved_at')->nullable();
            $table->text('rejection_reason')->nullable();
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamps();
            $table->softDeletes();
            $table->index(['tenant_id', 'expense_date']);
            $table->index(['tenant_id', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('expenses');
    }
};
