<?php

namespace Database\Seeders;

use App\Models\TaskStatus;
use Illuminate\Database\Seeder;

class TaskStatusSeeder extends Seeder
{
    public function run(): void
    {
        $statuses = [
            ['name' => 'To Do', 'color' => '#9E9E9E', 'position' => 1, 'is_default' => true],
            ['name' => 'In Progress', 'color' => '#2196F3', 'position' => 2],
            ['name' => 'In Review', 'color' => '#FF9800', 'position' => 3],
            ['name' => 'Done', 'color' => '#4CAF50', 'position' => 4, 'is_completed' => true],
            ['name' => 'Blocked', 'color' => '#F44336', 'position' => 5],
            ['name' => 'Cancelled', 'color' => '#607D8B', 'position' => 6, 'is_completed' => true],
        ];

        foreach ($statuses as $status) {
            TaskStatus::updateOrCreate(
                ['name' => $status['name'], 'tenant_id' => null, 'project_id' => null],
                array_merge($status, [
                    'is_default' => $status['is_default'] ?? false,
                    'is_completed' => $status['is_completed'] ?? false,
                ])
            );
        }
    }
}
