<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Tenant;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        $tenant = Tenant::first();
        
        if (!$tenant) {
            return;
        }

        // Admin user
        User::firstOrCreate(
            ['email' => 'admin@setupinbahrain.com'],
            [
                'tenant_id' => $tenant->id,
                'name' => 'System Admin',
                'email' => 'admin@setupinbahrain.com',
                'password' => Hash::make('password'),
                'role' => 'admin',
                'status' => 'active',
                'email_verified_at' => now(),
            ]
        );

        // Demo manager
        User::firstOrCreate(
            ['email' => 'manager@setupinbahrain.com'],
            [
                'tenant_id' => $tenant->id,
                'name' => 'Demo Manager',
                'email' => 'manager@setupinbahrain.com',
                'password' => Hash::make('password'),
                'role' => 'manager',
                'status' => 'active',
                'email_verified_at' => now(),
            ]
        );

        // Demo member
        User::firstOrCreate(
            ['email' => 'member@setupinbahrain.com'],
            [
                'tenant_id' => $tenant->id,
                'name' => 'Demo Member',
                'email' => 'member@setupinbahrain.com',
                'password' => Hash::make('password'),
                'role' => 'member',
                'status' => 'active',
                'email_verified_at' => now(),
            ]
        );
    }
}
