#!/bin/bash
# Docker Deployment Script

set -e

echo "🐳 Starting Docker deployment..."

# Build and start containers
docker-compose up -d --build

# Wait for MySQL
echo "Waiting for MySQL..."
sleep 10

# Run migrations inside container
docker-compose exec app php artisan migrate --force
docker-compose exec app php artisan db:seed --force
docker-compose exec app php artisan storage:link

echo "✅ Docker deployment complete!"
echo "Access your application at http://localhost"
